// Generated by CoffeeScript 1.12.1
(function() {
  var Adapter, MinifyHTML, W, defaults,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  Adapter = require('../../adapter_base');

  W = require('when');

  defaults = require('lodash.defaults');

  MinifyHTML = (function(superClass) {
    var compile;

    extend(MinifyHTML, superClass);

    function MinifyHTML() {
      return MinifyHTML.__super__.constructor.apply(this, arguments);
    }

    MinifyHTML.prototype.name = 'minify-html';

    MinifyHTML.prototype.extensions = ['html'];

    MinifyHTML.prototype.output = 'html';

    MinifyHTML.prototype.supportedEngines = ['html-minifier'];


    /**
     * I think that you could cause this to not be isolated by using the minifyCSS
       option and then making that import stylesheets, but I'm not even sure if
       MinifyHTML would support that...
     */

    MinifyHTML.prototype.isolated = true;

    MinifyHTML.prototype._render = function(str, options) {
      options = defaults(options, {
        removeComments: true,
        collapseWhitespace: true,
        removeEmptyAttributes: true
      });
      return compile((function(_this) {
        return function() {
          return _this.engine.minify(str, options);
        };
      })(this));
    };

    compile = function(fn) {
      var err, res;
      try {
        res = fn();
      } catch (error) {
        err = error;
        return W.reject(err);
      }
      return W.resolve({
        result: res
      });
    };

    return MinifyHTML;

  })(Adapter);

  module.exports = MinifyHTML;

}).call(this);
